/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Set;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class MBeanDumper {
    private static final Log log = LogFactory.getLog(MBeanDumper.class);
    protected static final StringManager sm = StringManager.getManager(MBeanDumper.class);
    private static final String CRLF = "\r\n";

    public static String dumpBeans(MBeanServer mBeanServer, Set<ObjectName> set) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ObjectName objectName : set) {
            stringBuilder.append("Name: ");
            stringBuilder.append(objectName.toString());
            stringBuilder.append(CRLF);
            try {
                MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(objectName);
                String string = mBeanInfo.getClassName();
                if ("org.apache.commons.modeler.BaseModelMBean".equals(string)) {
                    string = (String)mBeanServer.getAttribute(objectName, "modelerType");
                }
                stringBuilder.append("modelerType: ");
                stringBuilder.append(string);
                stringBuilder.append(CRLF);
                MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
                Object object = null;
                for (MBeanAttributeInfo mBeanAttributeInfo : mBeanAttributeInfoArray) {
                    Serializable serializable;
                    String string2;
                    if (!mBeanAttributeInfo.isReadable() || "modelerType".equals(string2 = mBeanAttributeInfo.getName()) || string2.indexOf(61) >= 0 || string2.indexOf(58) >= 0 || string2.indexOf(32) >= 0) continue;
                    try {
                        object = mBeanServer.getAttribute(objectName, string2);
                    }
                    catch (JMRuntimeException jMRuntimeException) {
                        serializable = jMRuntimeException.getCause();
                        if (serializable instanceof UnsupportedOperationException) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)sm.getString("mBeanDumper.getAttributeError", new Object[]{string2, objectName}), (Throwable)jMRuntimeException);
                            continue;
                        }
                        if (serializable instanceof NullPointerException) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)sm.getString("mBeanDumper.getAttributeError", new Object[]{string2, objectName}), (Throwable)jMRuntimeException);
                            continue;
                        }
                        log.error((Object)sm.getString("mBeanDumper.getAttributeError", new Object[]{string2, objectName}), (Throwable)jMRuntimeException);
                        continue;
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                        log.error((Object)sm.getString("mBeanDumper.getAttributeError", new Object[]{string2, objectName}), throwable);
                        continue;
                    }
                    if (object == null) continue;
                    try {
                        String string3;
                        serializable = object.getClass();
                        if (((Class)serializable).isArray()) {
                            int n = Array.getLength(object);
                            StringBuilder stringBuilder2 = new StringBuilder("Array[" + ((Class)serializable).getComponentType().getName() + "] of length " + n);
                            if (n > 0) {
                                stringBuilder2.append(CRLF);
                            }
                            for (int i = 0; i < n; ++i) {
                                stringBuilder2.append("\t");
                                Object object2 = Array.get(object, i);
                                if (object2 == null) {
                                    stringBuilder2.append("NULL VALUE");
                                } else {
                                    try {
                                        stringBuilder2.append(MBeanDumper.escape(object2.toString()));
                                    }
                                    catch (Throwable throwable) {
                                        ExceptionUtils.handleThrowable((Throwable)throwable);
                                        stringBuilder2.append("NON-STRINGABLE VALUE");
                                    }
                                }
                                if (i >= n - 1) continue;
                                stringBuilder2.append(CRLF);
                            }
                            string3 = stringBuilder2.toString();
                        } else {
                            string3 = MBeanDumper.escape(object.toString());
                        }
                        stringBuilder.append(string2);
                        stringBuilder.append(": ");
                        stringBuilder.append(string3);
                        stringBuilder.append(CRLF);
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
            }
            stringBuilder.append(CRLF);
        }
        return stringBuilder.toString();
    }

    public static String escape(String string) {
        int n = string.indexOf(10);
        if (n < 0) {
            return string;
        }
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (n >= 0) {
            MBeanDumper.appendHead(stringBuilder, string, n2, n);
            stringBuilder.append("\\n\n ");
            n2 = n + 1;
            if (n == string.length() - 1) break;
            n = string.indexOf(10, n + 1);
        }
        if (n2 < string.length()) {
            MBeanDumper.appendHead(stringBuilder, string, n2, string.length());
        }
        return stringBuilder.toString();
    }

    private static void appendHead(StringBuilder stringBuilder, String string, int n, int n2) {
        if (n2 < 1) {
            return;
        }
        int n3 = n;
        while (n2 - n3 > 78) {
            stringBuilder.append(string.substring(n3, n3 + 78));
            stringBuilder.append("\n ");
            n3 += 78;
        }
        stringBuilder.append(string.substring(n3, n2));
    }
}

