/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.GeometryArray;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.QuadArrayRetained;

public class QuadArray
extends GeometryArray {
    QuadArray() {
    }

    public QuadArray(int n, int n2) {
        super(n, n2);
        if (n < 4 || n % 4 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("QuadArray0"));
        }
    }

    public QuadArray(int n, int n2, int n3, int[] nArray) {
        super(n, n2, n3, nArray);
        if (n < 4 || n % 4 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("QuadArray0"));
        }
    }

    public QuadArray(int n, int n2, int n3, int[] nArray, int n4, int[] nArray2) {
        super(n, n2, n3, nArray, n4, nArray2);
        if (n < 4 || n % 4 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("QuadArray0"));
        }
    }

    @Override
    void createRetained() {
        this.retained = new QuadArrayRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        QuadArrayRetained quadArrayRetained = (QuadArrayRetained)this.retained;
        int n = quadArrayRetained.getTexCoordSetCount();
        int[] nArray = null;
        int n2 = quadArrayRetained.getVertexAttrCount();
        int[] nArray2 = null;
        if (n > 0) {
            nArray = new int[quadArrayRetained.getTexCoordSetMapLength()];
            quadArrayRetained.getTexCoordSetMap(nArray);
        }
        if (n2 > 0) {
            nArray2 = new int[n2];
            quadArrayRetained.getVertexAttrSizes(nArray2);
        }
        QuadArray quadArray = new QuadArray(quadArrayRetained.getVertexCount(), quadArrayRetained.getVertexFormat(), n, nArray, n2, nArray2);
        quadArray.duplicateNodeComponent(this);
        return quadArray;
    }
}

