/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.actions;

import java.awt.event.ActionEvent;
import net.osmand.plus.OsmandSettings;
import net.osmand.render.RenderingRuleProperty;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.actions.OffRoadAction;

public class SetRenderingRule
extends OffRoadAction
implements OffRoadAction.SelectableAction {
    private RenderingRuleProperty mCustomProp;
    private String mValue;
    private boolean mIsDefault;

    public SetRenderingRule(OsmWindow pWin, RenderingRuleProperty pCustomProp) {
        super(pWin, pWin.getString("rendering_attr_" + pCustomProp.getAttrName() + "_name"), null);
        this.mCustomProp = pCustomProp;
        this.mValue = null;
        this.mIsDefault = false;
    }

    private static String valueToName(OsmWindow pWin, String value) {
        try {
            Integer.parseInt(value);
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            return pWin.getString("rendering_value_" + value + "_name");
        }
    }

    public SetRenderingRule(OsmWindow pWin, RenderingRuleProperty pCustomProp, String value, boolean isDefault) {
        super(pWin, SetRenderingRule.valueToName(pWin, value), null);
        this.mCustomProp = pCustomProp;
        this.mValue = value;
        this.mIsDefault = isDefault;
    }

    @Override
    public void actionPerformed(ActionEvent pE) {
        if (this.mValue != null) {
            OsmandSettings.CommonPreference<String> pref = this.getStringPreference();
            pref.set(this.mValue);
            if (this.mIsDefault) {
                pref.resetToDefault();
            }
        } else {
            OsmandSettings.CommonPreference<Boolean> pref;
            pref.set((pref = this.getPreference()).get() == false);
        }
        this.mContext.getDrawPanel().drawLater();
    }

    private OsmandSettings.CommonPreference<Boolean> getPreference() {
        OsmandSettings.CommonPreference<Boolean> pref = this.mContext.getSettings().getCustomRenderBooleanProperty(this.mCustomProp.getAttrName());
        return pref;
    }

    private OsmandSettings.CommonPreference<String> getStringPreference() {
        OsmandSettings.CommonPreference<String> pref = this.mContext.getSettings().getCustomRenderProperty(this.mCustomProp.getAttrName());
        return pref;
    }

    @Override
    public boolean isSelected() {
        if (this.mValue != null) {
            return this.mValue.equals(this.getStringPreference().get());
        }
        OsmandSettings.CommonPreference<Boolean> pref = this.getPreference();
        return pref.get();
    }
}

