/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.filters;

import java.util.Objects;
import java.util.Properties;

public class GenericFilter {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_INCLUSIVE = 10;
    public static final int TYPE_EXCLUSIVE = 20;
    protected static final int MODE_EQUALS = 1000;
    protected static final int MODE_CONTAINS = 1010;
    protected static final int MODE_STARTS_WITH = 1020;
    protected static final int MODE_ENDS_WITH = 1030;
    private static final String PROP_NAME = "NAME";
    private static final String PROP_VALUE = "VALUE";
    private static final String PROP_TYPE = "TYPE";
    private String name;
    private String value;
    private transient String[] values;
    private int type;
    private transient int[] modes;
    private Boolean isEmpty;
    private Boolean isAll;

    public GenericFilter() {
        this(null, "", 0);
    }

    public GenericFilter(GenericFilter other) {
        this(other.name, other.value, other.values, other.type, other.modes);
    }

    public GenericFilter(String name, String value, int type) {
        this(name, value, null, type, null);
    }

    public GenericFilter(Properties properties, String id) {
        this(GenericFilter.loadName(properties, id), GenericFilter.loadValue(properties, id), GenericFilter.loadType(properties, id));
    }

    private GenericFilter(String name, String value, String[] values, int type, int[] modes) {
        this.name = name;
        this.value = value;
        this.values = values;
        this.type = type;
        this.modes = modes;
    }

    public void copyFrom(GenericFilter other) {
        this.name = other.name;
        this.value = other.value;
        this.values = other.values;
        this.type = other.type;
        this.modes = other.modes;
        this.isEmpty = other.isEmpty;
        this.isAll = other.isAll;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final void setValue(String value) {
        this.value = value;
        this.valueChanged();
    }

    protected void valueChanged() {
        this.values = null;
        this.modes = null;
        this.isEmpty = null;
        this.isAll = null;
    }

    public final String getValue() {
        return this.value;
    }

    public final String[] getValues() {
        if (this.values == null) {
            this.values = this.computeValues(this.value);
        }
        return this.values;
    }

    public final void setType(int type) {
        this.type = type;
    }

    public final int getType() {
        return this.type;
    }

    public final int[] getModes() {
        if (this.modes == null) {
            this.modes = this.computeModes(this.getValues());
        }
        return this.modes;
    }

    public final boolean isEmpty() {
        if (this.isEmpty == null) {
            this.isEmpty = this.value.isEmpty();
        }
        return this.isEmpty;
    }

    public boolean isAll() {
        if (this.isAll == null) {
            this.isAll = this.isEmpty() || "*".equals(this.value) || "**".equals(this.value);
        }
        return this.isAll;
    }

    protected String[] computeValues(String _value) {
        return GenericFilter.values(_value);
    }

    public static String[] values(String _value) {
        return _value.replace(',', ' ').split(" +");
    }

    protected int[] computeModes(String[] _values) {
        int length = _values.length;
        int[] _modes = new int[length];
        for (int i = 0; i < length; ++i) {
            boolean endsWith;
            int vlength;
            String _value = _values[i];
            int n = vlength = _value == null ? 0 : _value.length();
            if (vlength == 0) {
                _modes[i] = 1010;
                continue;
            }
            boolean startsWith = _value.charAt(0) == '*';
            boolean bl = endsWith = _value.charAt(vlength - 1) == '*';
            if (startsWith) {
                _value = _value.substring(1);
            }
            if (endsWith) {
                _value = _value.substring(0, vlength - (startsWith ? 2 : 1));
            }
            _values[i] = _value;
            if (_value.isEmpty()) {
                _modes[i] = 1010;
                continue;
            }
            if (startsWith) {
                if (endsWith) {
                    _modes[i] = 1010;
                    continue;
                }
                _modes[i] = 1030;
                continue;
            }
            _modes[i] = endsWith ? 1020 : 1000;
        }
        return _modes;
    }

    public boolean passes(String string) {
        if (this.simplePasses(string)) {
            return true;
        }
        boolean inclusive = this.type == 10;
        String[] _values = this.getValues();
        int[] _modes = this.getModes();
        for (int i = 0; i < _values.length; ++i) {
            if (!this.matches(string, _values[i], _modes[i])) continue;
            return inclusive;
        }
        return !inclusive;
    }

    protected boolean simplePasses(String string) {
        boolean inclusive;
        if (this.type == 0) {
            return true;
        }
        boolean bl = inclusive = this.type == 10;
        if (this.isAll()) {
            return inclusive;
        }
        if (this.getValues().length == 0) {
            return inclusive;
        }
        return false;
    }

    protected boolean matches(String string, String filter, int mode) {
        if (filter.isEmpty()) {
            return true;
        }
        switch (mode) {
            case 1020: {
                return string.startsWith(filter);
            }
            case 1000: {
                return string.equals(filter);
            }
            case 1030: {
                return string.endsWith(filter);
            }
            case 1010: {
                return string.contains(filter);
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().isAssignableFrom(this.getClass()) && !this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        return this.valuesEquals(obj);
    }

    protected boolean valuesEquals(Object obj) {
        GenericFilter other = (GenericFilter)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!this.value.equals(other.value)) {
            return false;
        }
        return this.type == other.type;
    }

    public int hashCode() {
        return this.valuesHashCode(3);
    }

    protected int valuesHashCode(int hashBase) {
        if (this.name != null) {
            hashBase = 67 * hashBase + this.name.hashCode();
        }
        hashBase = 67 * hashBase + this.value.hashCode();
        hashBase = 67 * hashBase + this.type;
        return hashBase;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getName());
        b.append("[");
        b.append("name: ").append(this.getName());
        b.append(", value: ").append(this.getValue());
        b.append(", type: ").append(GenericFilter.typeString(this.getType()));
        b.append("]");
        return b.toString();
    }

    private static String typeString(int type) {
        switch (type) {
            case 0: {
                return "TYPE_NONE";
            }
            case 10: {
                return "TYPE_INCLUSIVE";
            }
            case 20: {
                return "TYPE_EXCLUSIVE";
            }
        }
        return "unknown";
    }

    public void store(Properties properties, String id) {
        if (this.name == null) {
            properties.remove(id + PROP_NAME);
        } else {
            properties.put(id + PROP_NAME, this.name);
        }
        properties.put(id + PROP_VALUE, this.value);
        properties.put(id + PROP_TYPE, Integer.toString(this.type));
    }

    private static String loadName(Properties properties, String id) {
        return properties.getProperty(id + PROP_NAME);
    }

    private static String loadValue(Properties properties, String id) {
        String _value = properties.getProperty(id + PROP_VALUE);
        if (_value == null) {
            throw new InvalidFilterIdException("No filter value found", id);
        }
        return _value;
    }

    private static int loadType(Properties properties, String id) {
        String _type = properties.getProperty(id + PROP_TYPE);
        if (_type == null) {
            throw new InvalidFilterIdException("No filter type found", id);
        }
        try {
            return Integer.parseInt(_type);
        }
        catch (NumberFormatException e) {
            throw new InvalidFilterIdException("Bad filter type specified", id);
        }
    }

    public static final class InvalidFilterIdException
    extends IllegalArgumentException {
        public InvalidFilterIdException(String message, String filterId) {
            super(message + " for filter id " + filterId);
        }
    }
}

