/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.ShaderId;

abstract class ShaderRetained
extends NodeComponentRetained {
    int shadingLanguage;
    int shaderType;
    ShaderData[] shaderData;
    boolean compileErrorOccurred = false;
    Object resourceLock = new Object();

    ShaderRetained() {
    }

    void initializeShader(int n, int n2) {
        this.shadingLanguage = n;
        this.shaderType = n2;
    }

    int getShadingLanguage() {
        return this.shadingLanguage;
    }

    int getShaderType() {
        return this.shaderType;
    }

    @Override
    void setLive(boolean bl, int n) {
        super.setLive(bl, n);
    }

    @Override
    void clearLive(int n) {
        super.clearLive(n);
    }

    @Override
    synchronized void updateMirrorObject(int n, Object object) {
        System.err.println("Shader.updateMirrorObject not implemented yet!");
    }

    @Override
    void handleFrequencyChange(int n) {
        System.err.println("Shader.handleFrequencyChange not implemented yet!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createShaderData(int n, long l) {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.shaderData == null) {
                this.shaderData = new ShaderData[n + 1];
            } else if (this.shaderData.length <= n) {
                ShaderData[] shaderDataArray = new ShaderData[n + 1];
                System.arraycopy(this.shaderData, 0, shaderDataArray, 0, this.shaderData.length);
                this.shaderData = shaderDataArray;
            }
            if (this.shaderData[n] == null) {
                this.shaderData[n] = new ShaderData();
            } else if (this.shaderData[n].getCtxTimeStamp() != l) {
                this.shaderData[n].reset();
            }
            this.shaderData[n].setCtxTimeStamp(l);
        }
    }

    class ShaderData {
        private long ctxTimeStamp;
        private ShaderId shaderId = null;
        private boolean compiled = false;

        ShaderData() {
        }

        void reset() {
            this.ctxTimeStamp = 0L;
            this.shaderId = null;
            this.compiled = false;
        }

        long getCtxTimeStamp() {
            return this.ctxTimeStamp;
        }

        void setCtxTimeStamp(long l) {
            this.ctxTimeStamp = l;
        }

        ShaderId getShaderId() {
            return this.shaderId;
        }

        void setShaderId(ShaderId shaderId) {
            this.shaderId = shaderId;
        }

        boolean isCompiled() {
            return this.compiled;
        }

        void setCompiled(boolean bl) {
            this.compiled = bl;
        }
    }
}

