/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.ui.components.ScalePanel;
import net.sf.sdedit.ui.components.ZoomPane;
import net.sf.sdedit.ui.components.Zoomable;

public class FullScreen
extends JFrame
implements KeyListener,
ActionListener {
    private static final long serialVersionUID = -1422640862L;
    private ZoomPane zoomPane;
    private GraphicsDevice gd;
    private ScalePanel scalePanel;
    private boolean locked;
    private JPanel closePanel;
    private Timer hideClosePanelTimer;
    private static final ImageIcon noFullScreenIcon = Icons.getIcon("large/nofullscreen");
    private MouseMotionListener mml = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            FullScreen.this.hideClosePanelTimer.restart();
            FullScreen.this.closePanel.setVisible(true);
        }
    };
    private MouseListener ml = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            FullScreen.this.locked = true;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            FullScreen.this.locked = false;
        }
    };

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.hideClosePanelTimer) {
            if (!this.locked && this.closePanel.isVisible()) {
                this.closePanel.setVisible(false);
                this.getContentPane().repaint();
            }
        } else {
            this.returnFromFullScreenMode();
        }
    }

    public FullScreen() {
        this.gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.zoomPane = new ZoomPane();
        this.zoomPane.setRoot((JComponent)this.getGlassPane());
        this.getContentPane().setLayout(new BorderLayout());
        JButton close = new JButton(noFullScreenIcon);
        close.setMargin(new Insets(0, 0, 0, 0));
        close.addActionListener(this);
        this.getContentPane().add((Component)this.zoomPane, "Center");
        this.addKeyListener(this);
        this.setUndecorated(true);
        this.scalePanel = new ScalePanel(true);
        this.scalePanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.scalePanel.getSlider().addMouseListener(this.ml);
        this.scalePanel.setScalable(this.zoomPane);
        this.closePanel = new JPanel();
        this.closePanel.setLayout(new BorderLayout());
        this.closePanel.add((Component)close, "East");
        this.closePanel.add((Component)this.scalePanel, "Center");
        JPanel glass = (JPanel)this.getGlassPane();
        glass.setVisible(true);
        glass.setLayout(new BorderLayout());
        JPanel top = new JPanel();
        top.setOpaque(false);
        top.setLayout(new BorderLayout());
        glass.add((Component)top, "North");
        top.add((Component)this.closePanel, "East");
        this.hideClosePanelTimer = new Timer(1000, this);
        this.hideClosePanelTimer.start();
    }

    public ZoomPane getZoomPane() {
        return this.zoomPane;
    }

    public ScalePanel getScalePanel() {
        return this.scalePanel;
    }

    public void display(Zoomable<? extends JComponent> comp) {
        this.gd.setFullScreenWindow(this);
        this.setVisible(true);
        comp.asJComponent().removeMouseMotionListener(this.mml);
        comp.asJComponent().addMouseMotionListener(this.mml);
        this.zoomPane.setViewportView(comp);
        this.closePanel.setVisible(false);
        this.locked = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FullScreen.this.requestFocus();
            }
        });
    }

    private void returnFromFullScreenMode() {
        this.gd.setFullScreenWindow(null);
        this.setVisible(false);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 || KeyEvent.getKeyText(e.getKeyCode()).equals("F9")) {
            this.returnFromFullScreenMode();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

