/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Predicate;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.DefaultMap;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.java.analysis.ControlFlowEdge;
import com.strobel.decompiler.languages.java.analysis.ControlFlowGraphBuilder;
import com.strobel.decompiler.languages.java.analysis.ControlFlowNode;
import com.strobel.decompiler.languages.java.analysis.ControlFlowNodeType;
import com.strobel.decompiler.languages.java.analysis.Correlator;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.BreakStatement;
import com.strobel.decompiler.languages.java.ast.CaseLabel;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.DepthFirstAstVisitor;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.JavaResolver;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.LabelStatement;
import com.strobel.decompiler.languages.java.ast.LabeledStatement;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.NullReferenceExpression;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SwitchExpression;
import com.strobel.decompiler.languages.java.ast.SwitchExpressionArm;
import com.strobel.decompiler.languages.java.ast.SwitchSection;
import com.strobel.decompiler.languages.java.ast.SwitchStatement;
import com.strobel.decompiler.languages.java.ast.ThrowStatement;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import com.strobel.decompiler.patterns.AnyNode;
import com.strobel.decompiler.patterns.Choice;
import com.strobel.decompiler.patterns.IdentifierBackReference;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.NamedNode;
import com.strobel.decompiler.patterns.TypedNode;
import com.strobel.functions.Supplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class RewriteSwitchExpressionsTransform
extends ContextTrackingVisitor<Void> {
    private final ExpressionStatement resultAssignment;
    private final ExpressionStatement firstResultAssignment;
    private final VariableDeclarationStatement resultDeclaration;

    public RewriteSwitchExpressionsTransform(DecompilerContext context) {
        super(context);
        VariableDeclarationStatement vd = new VariableDeclarationStatement();
        vd.setType(new NamedNode("resultType", new AnyNode()).toType());
        vd.setAnyModifiers(true);
        vd.getVariables().add(new NamedNode("resultInitializer", new VariableInitializer("$any$", new NamedNode("initValue", new Choice(new TypedNode(PrimitiveExpression.class), new NullReferenceExpression())).toExpression())).toVariableInitializer());
        this.resultDeclaration = vd;
        this.firstResultAssignment = new ExpressionStatement(new AssignmentExpression(new NamedNode("resultInitializer", new IdentifierExpression("$any$")).toExpression(), new NamedNode("yieldedValue", new TypedNode(Expression.class)).toExpression()));
        this.resultAssignment = new ExpressionStatement(new AssignmentExpression(new IdentifierBackReference("resultInitializer").toExpression(), new NamedNode("yieldedValue", new TypedNode(Expression.class)).toExpression()));
    }

    @Override
    public void run(AstNode compilationUnit) {
        super.run(compilationUnit);
    }

    @Override
    public Void visitSwitchStatement(final SwitchStatement switchNode, Void data) {
        boolean bl;
        CaseInfo caseInfo;
        super.visitSwitchStatement(switchNode, data);
        ControlFlowGraphBuilder graphBuilder = new ControlFlowGraphBuilder();
        List<ControlFlowNode> nodes = graphBuilder.buildControlFlowGraph(switchNode, new JavaResolver(this.context));
        final HashSet nestedLabels = new HashSet();
        switchNode.acceptVisitor(new DepthFirstAstVisitor<Void, Void>(){

            @Override
            public Void visitLabelStatement(LabelStatement node, Void data) {
                nestedLabels.add(node.getLabel());
                return (Void)super.visitLabelStatement(node, data);
            }

            @Override
            public Void visitLabeledStatement(LabeledStatement node, Void data) {
                nestedLabels.add(node.getLabel());
                return (Void)super.visitLabeledStatement(node, data);
            }
        }, null);
        List<ControlFlowNode> endNodes = CollectionUtilities.toList(CollectionUtilities.where(nodes, new Predicate<ControlFlowNode>(){

            @Override
            public boolean test(ControlFlowNode node) {
                Statement ps = node.getPreviousStatement();
                return node.getType() == ControlFlowNodeType.EndNode && ps != switchNode && ps != null && !(ps instanceof BlockStatement) && ps.getParent(SwitchStatement.class) == switchNode;
            }
        }));
        SwitchInfo info = new SwitchInfo();
        ArrayList<BreakStatement> breaks = new ArrayList<BreakStatement>();
        ArrayList<ThrowStatement> throwStatements = new ArrayList<ThrowStatement>();
        ArrayList<ControlFlowNode> possibleFallThroughNodes = new ArrayList<ControlFlowNode>();
        block0: for (ControlFlowNode controlFlowNode : endNodes) {
            Statement statement = controlFlowNode.getPreviousStatement();
            if (statement instanceof BreakStatement) {
                BreakStatement br = (BreakStatement)statement;
                if (!StringUtilities.isNullOrEmpty(br.getLabel()) && !nestedLabels.contains(br.getLabel())) {
                    return null;
                }
                breaks.add(br);
                continue;
            }
            if (statement instanceof ThrowStatement) {
                throwStatements.add((ThrowStatement)statement);
                continue;
            }
            if (AstNode.isUnconditionalBranch(statement)) {
                return null;
            }
            for (ControlFlowEdge edge : controlFlowNode.getOutgoing()) {
                if (edge.getTo() == null || edge.getTo().getOutgoing().size() == 0) continue;
                continue block0;
            }
            possibleFallThroughNodes.add(controlFlowNode);
            info.needClassicStyle = true;
        }
        if (breaks.isEmpty()) {
            return null;
        }
        IdentifierExpression firstAssignment = null;
        for (BreakStatement breakStatement : breaks) {
            SwitchSection ss;
            Match m = Match.createNew();
            Statement bp = breakStatement.getPreviousStatement();
            if (firstAssignment != null) {
                m.add("resultInitializer", firstAssignment);
                if (!this.resultAssignment.matches(bp, m)) {
                    return null;
                }
            } else if (this.firstResultAssignment.matches(bp, m)) {
                info.resultIdentifier = firstAssignment = (IdentifierExpression)CollectionUtilities.first(m.get("resultInitializer"));
                info.resultVariable = firstAssignment.getUserData(Keys.VARIABLE);
                if (info.resultVariable == null) {
                    return null;
                }
            } else {
                return null;
            }
            if ((ss = breakStatement.getParent(SwitchSection.class)) == null || ss.isNull()) {
                return null;
            }
            CaseInfo caseInfo2 = info.cases.get(ss);
            caseInfo2.breaks.add(breakStatement);
            caseInfo2.yieldedValues.put(breakStatement, (Expression)CollectionUtilities.first(m.get("yieldedValue")));
            caseInfo2.isDefault = ss.getCaseLabels().isEmpty() || ss.getCaseLabels().size() == 1 && ss.getCaseLabels().firstOrNullObject().getExpression().isNull();
        }
        if (info.resultIdentifier == null) {
            return null;
        }
        for (ThrowStatement throwStatement : throwStatements) {
            SwitchSection ss = throwStatement.getParent(SwitchSection.class);
            if (ss == null || ss.isNull()) {
                return null;
            }
            info.cases.get((Object)ss).hasThrows = true;
        }
        for (ControlFlowNode controlFlowNode : possibleFallThroughNodes) {
            block30: {
                block29: {
                    SwitchSection ss;
                    Statement ps = controlFlowNode.getPreviousStatement();
                    SwitchSection switchSection = ss = ps != null ? ps.getParent(SwitchSection.class) : null;
                    if (ss == null) break block29;
                    caseInfo = info.cases.get(ss);
                    if (caseInfo.breaks.isEmpty()) break block30;
                }
                return null;
            }
            caseInfo.hasFallThrough = true;
        }
        boolean bl2 = false;
        for (SwitchSection section : switchNode.getSwitchSections()) {
            boolean isEmpty = !info.cases.containsKey(section);
            caseInfo = info.cases.get(section);
            if (isEmpty) {
                caseInfo.isEmpty = true;
            }
            if (isEmpty || caseInfo.hasFallThrough) {
                bl = true;
                continue;
            }
            if (!caseInfo.hasThrows && caseInfo.yieldedValues.isEmpty()) continue;
            bl = false;
        }
        if (bl) {
            return null;
        }
        boolean bl3 = Correlator.areCorrelated(info.resultIdentifier.clone(), switchNode);
        if (bl3) {
            return null;
        }
        this.rewrite(switchNode, info);
        if (info.resultVariable.isGenerated()) {
            new SwitchExpressionInlining(info).tryInline();
        }
        return null;
    }

    private void rewrite(SwitchStatement node, SwitchInfo info) {
        VariableInitializer vi;
        Match m;
        AstNodeCollection<SwitchSection> sections = node.getSwitchSections();
        SwitchExpression se = new SwitchExpression();
        for (SwitchSection ss : sections) {
            Statement newFirst;
            Expression value;
            BlockStatement b;
            CaseInfo caseInfo = info.cases.get(ss);
            AstNodeCollection<Statement> statements = ss.getStatements();
            Statement first = statements.firstOrNullObject();
            SwitchExpressionArm arm = new SwitchExpressionArm();
            if (statements.size() == 1 && first instanceof BlockStatement) {
                b = (BlockStatement)first;
                b.remove();
            } else {
                b = new BlockStatement();
                for (Statement statement : statements) {
                    statement.remove();
                    b.add(statement);
                }
            }
            for (CaseLabel label : ss.getCaseLabels()) {
                value = label.getExpression();
                if (value.isNull()) {
                    arm.setDefaultCase(true);
                    continue;
                }
                value.remove();
                arm.getValues().add(value);
            }
            for (BreakStatement br : caseInfo.breaks) {
                value = caseInfo.yieldedValues.get(br);
                Statement parentStatement = value.getParent(Statement.class);
                assert (parentStatement != null);
                parentStatement.remove();
                value.remove();
                br.setYield(true);
                br.setValue(value);
            }
            if (!info.needClassicStyle && b.getStatements().size() == 1 && !(newFirst = b.getStatements().firstOrNullObject()).isNull()) {
                if (newFirst instanceof BreakStatement) {
                    Expression value2 = ((BreakStatement)newFirst).getValue();
                    value2.remove();
                    arm.getStatements().add(new ExpressionStatement(value2));
                } else if (newFirst instanceof ThrowStatement) {
                    newFirst.remove();
                    arm.getStatements().add(newFirst);
                } else {
                    arm.getStatements().add(b);
                }
            } else {
                arm.getStatements().add(b);
            }
            arm.setClassicStyle(info.needClassicStyle);
            se.getArms().add(arm);
        }
        Expression governingExpression = node.getExpression();
        governingExpression.remove();
        se.setGoverningExpression(governingExpression);
        Statement ps = node.getPreviousStatement();
        Match match = m = ps != null ? this.resultDeclaration.match(ps) : Match.failure();
        if (m.success() && info.resultVariable == (vi = (VariableInitializer)CollectionUtilities.first(m.get("resultInitializer"))).getUserData(Keys.VARIABLE)) {
            info.rewrittenDeclaration = vi.getParent(VariableDeclarationStatement.class);
            vi.getInitializer().replaceWith(se);
            node.remove();
        } else {
            info.rewrittenAssignment = new ExpressionStatement(new AssignmentExpression(info.resultIdentifier.clone(), se));
            node.replaceWith(info.rewrittenAssignment);
        }
        info.rewrittenExpression = se;
    }

    static final class SwitchInfo {
        IdentifierExpression resultIdentifier;
        Variable resultVariable;
        SwitchExpression rewrittenExpression;
        ExpressionStatement rewrittenAssignment;
        VariableDeclarationStatement rewrittenDeclaration;
        final Map<SwitchSection, CaseInfo> cases = new DefaultMap<SwitchSection, CaseInfo>(new Supplier<CaseInfo>(){

            @Override
            public CaseInfo get() {
                return new CaseInfo();
            }
        });
        boolean needClassicStyle;

        SwitchInfo() {
        }
    }

    static final class CaseInfo {
        final List<BreakStatement> breaks = new ArrayList<BreakStatement>();
        final Map<BreakStatement, Expression> yieldedValues = new HashMap<BreakStatement, Expression>();
        boolean isEmpty;
        boolean isDefault;
        boolean hasThrows;
        boolean hasFallThrough;

        CaseInfo() {
        }
    }

    private final class SwitchExpressionInlining
    extends ContextTrackingVisitor<Void> {
        private final List<Expression> references;
        private final SwitchInfo info;
        private final MethodDefinition currentMethod;

        SwitchExpressionInlining(SwitchInfo info) {
            super(new DecompilerContext(RewriteSwitchExpressionsTransform.this.context.getSettings()));
            this.references = new ArrayList<Expression>();
            this.info = info;
            this.currentMethod = RewriteSwitchExpressionsTransform.this.context.getCurrentMethod();
        }

        final void tryInline() {
            if (this.currentMethod == null || this.info.rewrittenExpression == null || this.info.rewrittenAssignment == null && this.info.rewrittenDeclaration == null) {
                return;
            }
            EntityDeclaration parentMethod = this.currentMethod.isConstructor() ? this.info.rewrittenExpression.getParent(ConstructorDeclaration.class) : this.info.rewrittenExpression.getParent(MethodDeclaration.class);
            if (parentMethod == null) {
                return;
            }
            parentMethod.acceptVisitor(this, null);
            if (this.references.size() == 1) {
                Expression target = this.references.get(0);
                if (this.info.rewrittenAssignment != null) {
                    this.info.rewrittenAssignment.remove();
                } else if (this.info.rewrittenDeclaration.getVariables().size() == 1) {
                    this.info.rewrittenDeclaration.remove();
                } else {
                    VariableInitializer vi = this.info.rewrittenDeclaration.getVariable(this.info.resultIdentifier.getIdentifier());
                    if (vi == null) {
                        return;
                    }
                    vi.remove();
                }
                this.info.rewrittenExpression.remove();
                target.replaceWith(this.info.rewrittenExpression);
            }
        }

        @Override
        public Void visitIdentifierExpression(IdentifierExpression node, Void data) {
            super.visitIdentifierExpression(node, data);
            if (node.getRole() == AssignmentExpression.LEFT_ROLE && node.getParent(ExpressionStatement.class) == this.info.rewrittenAssignment) {
                return null;
            }
            if (node.matches(this.info.resultIdentifier)) {
                this.references.add(node);
            }
            return null;
        }
    }
}

